<?php
// time.php - تبدیل تاریخ میلادی به شمسی (نسخه ایمن)

if (!function_exists('jdate')) {
    function jdate($format, $timestamp = null) {
        if ($timestamp === null) $timestamp = time();
        
        $g_y = (int)date('Y', $timestamp);
        $g_m = (int)date('m', $timestamp);
        $g_d = (int)date('d', $timestamp);
        
        $gy = $g_y - 1600;
        $gm = $g_m - 1;
        $gd = $g_d - 1;
        
        $g_day_no = 365 * $gy + floor(($gy + 3) / 4) - floor(($gy + 99) / 100) + floor(($gy + 399) / 400);
        
        for ($i = 0; $i < $gm; ++$i) {
            $g_day_no += [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][$i];
        }
        
        if ($gm > 1 && (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0))) {
            ++$g_day_no;
        }
        
        $g_day_no += $gd;
        $j_day_no = $g_day_no - 79;
        $j_np = floor($j_day_no / 12053);
        $j_day_no %= 12053;
        
        $jy = 979 + 33 * $j_np + 4 * floor($j_day_no / 1461);
        $j_day_no %= 1461;
        
        if ($j_day_no >= 366) {
            $jy += floor(($j_day_no - 1) / 365);
            $j_day_no = ($j_day_no - 1) % 365;
        }
        
        $j_month_days = [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29];
        if ($jy % 33 == 1 || $jy % 33 == 5 || $jy % 33 == 9 || $jy % 33 == 13 || 
            $jy % 33 == 17 || $jy % 33 == 22 || $jy % 33 == 26 || $jy % 33 == 30) {
            $j_month_days[11] = 30;
        }
        
        $jm = 0;
        while ($j_day_no >= $j_month_days[$jm]) {
            $j_day_no -= $j_month_days[$jm];
            ++$jm;
        }
        
        $jd = $j_day_no + 1;
        ++$jm;
        
        $output = $format;
        $output = str_replace('Y', $jy, $output);
        $output = str_replace('m', str_pad($jm, 2, '0', STR_PAD_LEFT), $output);
        $output = str_replace('d', str_pad($jd, 2, '0', STR_PAD_LEFT), $output);
        $output = str_replace('H', date('H', $timestamp), $output);
        $output = str_replace('i', date('i', $timestamp), $output);
        $output = str_replace('s', date('s', $timestamp), $output);
        
        return $output;
    }
}

// توابع کاربری (بدون نیاز به محافظ، چون فقط یک‌بار لود می‌شوند)
function isUserCharged($user_id) {
    $stmt = db()->prepare("
        SELECT 1 FROM groups
        WHERE owner_id = ? AND expires_at > NOW()
        LIMIT 1
    ");
    $stmt->execute([$user_id]);
    return (bool)$stmt->fetch();
}

function getUserExpiryDate($user_id) {
    $stmt = db()->prepare("
        SELECT MAX(expires_at) as expiry
        FROM groups
        WHERE owner_id = ?
    ");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch();
    return $row ? $row['expiry'] : null;
}