<?php

// تابع اصلی برای مدیریت کلیک‌های منوی پی‌وی
function handlePvCallback($callback_query) {
    $data = $callback_query['data'];
    $user_id = $callback_query['from']['id'];
    $chat_id = $callback_query['message']['chat']['id'];
    $message_id = $callback_query['message']['message_id'];

    // برای جلوگیری از لودینگ بی‌مورد روی دکمه
    sendTelegram('answerCallbackQuery', ['callback_query_id' => $callback_query['id']]);

    switch ($data) {
        case 'pv_main':
            showMainMenu($user_id, $chat_id, $message_id);
            break;
        case 'pv_help':
            showHelpMenu($user_id, $chat_id, $message_id);
            break;
        case 'pv_owner':
            showOwnerMenu($user_id, $chat_id, $message_id);
            break;
        case 'pv_addgroup':
            showAddGroupMenu($user_id, $chat_id, $message_id);
            break;
        case 'pv_support':
            showSupportMenu($user_id, $chat_id, $message_id);
            break;
        case 'pv_account':
            showAccountMenu($user_id, $chat_id, $message_id);
            break;
    }
}

function showMainMenu($user_id, $chat_id, $message_id_to_edit = null) {
    $photo_url = 'https://khan9.ir/Ebi1/a.jpg';
    
    $welcome_text = "🤖 <b>سلام به ربات مدیریت گروه!</b>\n\n";
    $welcome_text .= "من یک ربات حرفه‌ای برای مدیریت گروه‌های تلگرام هستم.\n";
    $welcome_text .= "برای شروع، از منوی زیر استفاده کنید.\n\n";
    
    // اطلاعات کاربر
    $stmt = db()->prepare("SELECT first_name, last_name, username FROM user_cache WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch();
    
    if ($row) {
        $first_name = $row['first_name'] ?? 'کاربر';
        $last_name = $row['last_name'] ?? '';
        $username = $row['username'] ? '@' . $row['username'] : 'ندارد';
        
        $welcome_text .= "👤 <b>اطلاعات شما:</b>\n";
        $welcome_text .= "• نام: " . htmlspecialchars($first_name . ' ' . $last_name) . "\n";
        $welcome_text .= "• یوزرنیم: $username\n";
    }

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '📖 راهنما', 'callback_data' => 'pv_help']],
            [
                ['text' => '👨‍💻 سازنده', 'callback_data' => 'pv_owner'],
                ['text' => '➕ افزودن به گروه', 'callback_data' => 'pv_addgroup']
            ],
            [
                ['text' => '🛟 پشتیبانی', 'callback_data' => 'pv_support'],
                ['text' => '📂 حساب کاربری', 'callback_data' => 'pv_account']
            ]
        ]
    ]);

    if ($message_id_to_edit) {
        // === اصلاح شد: همیشه پیام را ویرایش کن. بررسی تغییرات غیرضروری و باگ‌دار بود. ===
        sendTelegram('editMessageCaption', [
            'chat_id' => $chat_id,
            'message_id' => $message_id_to_edit,
            'caption' => $welcome_text,
            'parse_mode' => 'HTML',
            'reply_markup' => $keyboard
        ]);
    } else {
        // ارسال عکس جدید با کپشن
        sendTelegram('sendPhoto', [
            'chat_id' => $chat_id,
            'photo' => $photo_url,
            'caption' => $welcome_text,
            'parse_mode' => 'HTML',
            'reply_markup' => $keyboard
        ]);
    }
}

function showHelpMenu($user_id, $chat_id, $message_id_to_edit) {
    $help_text = "📖 <b>راهنمای استفاده از ربات</b>\n\n";
    $help_text .= "این ربات برای مدیریت پیشرفته گروه‌های تلگرام طراحی شده است.\n\n";
    $help_text .= "🔹 <b>قابلیت‌های اصلی:</b>\n";
    $help_text .= "• قفل انواع محتوا (لینک، استیکر، فوروارد، عکس و ...)\n";
    $help_text .= "• سیستم سطح دسترسی (مالک، مدیر، کاربر ویژه)\n";
    $help_text .= "• فعال‌سازی با کد اشتراک\n";
    $help_text .= "• محافظت از کاربران خاص\n\n";
    
    $help_text .= "📝 <b>نحوه استفاده:</b>\n";
    $help_text .= "1. ربات را به گروه اضافه کنید\n";
    $help_text .= "2. ربات را ادمین کنید (حداقل دسترسی: حذف پیام، بن کاربران)\n";
    $help_text .= "3. کد اشتراک بگیرید\n";
    $help_text .= "4. در گروه: <code>/activate کد</code>\n\n";
    $help_text .= "برای دریافت کد اشتراک با مالک ربات تماس بگیرید.";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'pv_main']]
        ]
    ]);

    sendTelegram('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id_to_edit,
        'caption' => $help_text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

function showOwnerMenu($user_id, $chat_id, $message_id_to_edit) {
    $owner_text = "👨‍💻 <b>سازنده ربات</b>\n\n";
    $owner_text .= "این ربات با دقت و تخصص طراحی و پیاده‌سازی شده است.\n\n";
    $owner_text .= "💡 <b>ویژگی‌های خاص:</b>\n";
    $owner_text .= "• کدنویسی تمیز و بهینه\n";
    $owner_text .= "• امنیت بالا\n";
    $owner_text .= "• رابط کاربری زیبا\n";
    $owner_text .= "• پشتیبانی از تاریخ شمسی\n\n";
    $owner_text .= "برای سفارش ربات‌های مشابه یا گزارش مشکل، از بخش پشتیبانی استفاده کنید.";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'pv_main']]
        ]
    ]);

    sendTelegram('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id_to_edit,
        'caption' => $owner_text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

function showAddGroupMenu($user_id, $chat_id, $message_id_to_edit) {
    $bot_username = BOT_USERNAME;
    $invite_link = "https://t.me/{$bot_username}?startgroup=1";

    $text = "➕ <b>افزودن ربات به گروه</b>\n\n";
    $text .= "📋 <b>مراحل افزودن:</b>\n\n";
    $text .= "1️⃣ روی دکمه زیر کلیک کنید و گروه مورد نظر را انتخاب کنید\n\n";
    $text .= "2️⃣ پس از افزودن، ربات را به عنوان ادمین کامل در گروه خود promote کنید.\n\n";
    $text .= "3️⃣ یک کد فعال‌سازی تهیه کرده و با دستور <code>/activate [کد]</code> در گروه، ربات را فعال کنید.";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🤖 افزودن ربات به گروه', 'url' => $invite_link]],
            [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'pv_main']]
        ]
    ]);

    sendTelegram('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id_to_edit,
        'caption' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

function showSupportMenu($user_id, $chat_id, $message_id_to_edit) {
    $owner_id = OWNER_ID;
    $support_text = "🛟 <b>پشتیبانی و ارتباط</b>\n\n";
    $support_text .= "برای دریافت راهنمایی و ارتباط با پشتیبانی، می‌توانید از طریق راه‌های زیر با ما در تماس باشید:\n\n";
    $support_text .= "💬 ایدی تلگرام مالک ربات (برای دریافت کد و پشتیبانی)";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '💬 ارتباط با مالک ربات', 'url' => "tg://user?id={$owner_id}"]],
            [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'pv_main']]
        ]
    ]);

    sendTelegram('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id_to_edit,
        'caption' => $support_text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

function showAccountMenu($user_id, $chat_id, $message_id_to_edit) {
    // Get groups where user is owner
    $stmt = db()->prepare("SELECT g.chat_id, g.expires_at FROM groups g WHERE g.owner_id = ?");
    $stmt->execute([$user_id]);
    $owned_groups = $stmt->fetchAll();

    $text = "📂 <b>حساب کاربری شما</b>\n\n";
    
    if (empty($owned_groups)) {
        $text .= "شما در حال حاضر مالک هیچ گروه فعالی نیستید.\n\n";
        $text .= "💡 برای شروع، ربات را به گروه خود اضافه کرده و با کد فعال‌سازی آن را فعال کنید.";
    } else {
        $text .= "👑 <b>گروه‌های شما (که مالک آن هستید):</b>\n\n";
        foreach ($owned_groups as $group) {
            $status = ($group['expires_at'] > date('Y-m-d H:i:s')) ? '✅ فعال' : '❌ منقضی';
            $jalali_expiry = jdate('Y/m/d H:i', strtotime($group['expires_at']));
            $text .= "• گروه: <code>{$group['chat_id']}</code>\n";
            $text .= "  وضعیت: $status\n";
            $text .= "  انقضا: $jalali_expiry\n\n";
        }
    }
    
    $text .= "برای تمدید یا دریافت کد با پشتیبانی تماس بگیرید.";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'pv_main']]
        ]
    ]);

    sendTelegram('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id_to_edit,
        'caption' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}