<?php
/**
 * ═══════════════════════════════════════════════════════
 * 🔞 P - آنتی پورن هوشمند (نسخه پیشرفته با تایمر)
 * ═══════════════════════════════════════════════════════
 * قابلیت‌ها:
 * - تشخیص متن/عکس/ویدیو/گیف با هوش مصنوعی
 * - قفل دائمی و موقت (روزانه/ساعتی)
 * - جلوگیری از تکرار دستورات
 * - اعلان خودکار انقضا به گروه و سودو
 * - حالت Safe Mode برای حذف خودکار در صورت مشکل API
 */

require_once 'config.php';
require_once 'jdate.php';

// ═══════════════════════════════════════════════════════
// 🔑 تنظیمات API
// ═══════════════════════════════════════════════════════
define('SIGHTENGINE_USER', '640367803');
define('SIGHTENGINE_SECRET', '9qgzBtyxCSkHo9YsadMYJEyZtYYZmk9s');

// ✅ لیست کلمات بد - جامع و کامل
$badWordsList = [
    // فارسی
    'سکس', 'کیر', 'کص', 'کون', 'جنده', 'پورن', 'ممه', 'کس', 'کسشر',
    'خاله', 'صیغه', 'زناشویی', 'ماساژ', 'ساک', 'لز', 'گی', 'فاعل', 
    'مفعول', 'جق', 'ارضا', 'لذت', 'شهوت', 'عشق بازی', 'رابطه', 'سوپر',
    'فیلم سکسی', 'عکس سکسی', 'داستان سکسی', 'چت سکسی',
    
    // انگلیسی
    'porn', 'xxx', 'sex', 'nude', 'naked', 'ass', 'pussy', 'dick', 
    'fuck', 'cock', 'bitch', 'slut', 'whore', 'boobs', 'tits', 'penis',
    'vagina', 'anal', 'oral', 'blowjob', 'handjob', 'masturbat', 'orgasm',
    'horny', 'sexy', 'naughty', 'adult', 'nsfw', 'r34', 'hentai', 'ecchi',
    
    // سایر زبان‌ها
    'partnyor', 'sexo', 'porno', 'sexe'
];

// ═══════════════════════════════════════════════════════
// 🗄️ مایگریشن دیتابیس
// ═══════════════════════════════════════════════════════
function migratePornLockTable(): void
{
    $db = Database::instance()->pdo();
    
    // ✅ جدول قفل‌ها با ستون expire_time
    try {
        $db->exec("CREATE TABLE IF NOT EXISTS mia_locks (
            id INT AUTO_INCREMENT PRIMARY KEY,
            group_id BIGINT NOT NULL,
            lock_type VARCHAR(50) NOT NULL,
            is_active TINYINT(1) DEFAULT 0,
            expire_time DATETIME DEFAULT NULL,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY unique_lock (group_id, lock_type),
            INDEX idx_group_id (group_id),
            INDEX idx_lock_type (lock_type),
            INDEX idx_expire (expire_time)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
        // بررسی و اضافه کردن ستون expire_time اگر وجود ندارد
        $stmt = $db->query("SHOW COLUMNS FROM mia_locks LIKE 'expire_time'");
        if ($stmt->rowCount() === 0) {
            $db->exec("ALTER TABLE mia_locks ADD COLUMN expire_time DATETIME DEFAULT NULL AFTER is_active");
        }
    } catch (PDOException $e) {
        error_log("Porn Lock Migration Error: " . $e->getMessage());
    }
    
    // ✅ جدول اخطارها
    $db->exec("
        CREATE TABLE IF NOT EXISTS user_warnings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            group_id BIGINT NOT NULL,
            user_id BIGINT NOT NULL,
            warning_count INT DEFAULT 0,
            last_warning DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY unique_warning (group_id, user_id),
            INDEX idx_group_user (group_id, user_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
}
migratePornLockTable();

// ═══════════════════════════════════════════════════════
// 🤖 توابع هوش مصنوعی
// ═══════════════════════════════════════════════════════
function getTelegramFilePath(string $fileId): ?string
{
    $response = tgRequest('getFile', ['file_id' => $fileId]);
    if (isset($response['result']['file_path'])) {
        return "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $response['result']['file_path'];
    }
    return null;
}

function checkImageWithAI(string $imageUrl): array
{
    // 🔴 حالت محافظتی: اگر API غیرفعال است، همه مدیا را مشکوک بدان
    if (SIGHTENGINE_USER === '640367803' || empty(SIGHTENGINE_SECRET)) {
        // ⚠️ حذف خودکار تمام عکس/استیکر/گیف در حالت قفل پورن
        return ['detected' => true, 'reason' => 'safe_mode_strict'];
    }

    $params = [
        'models' => 'nudity-2.1,wad,offensive',  // ✅ مدل‌های بیشتر
        'api_user' => SIGHTENGINE_USER,
        'api_secret' => SIGHTENGINE_SECRET,
        'url' => $imageUrl
    ];

    $ch = curl_init('https://api.sightengine.com/1.0/check.json?' . http_build_query($params));
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 8,
        CURLOPT_SSL_VERIFYPEER => false  // ✅ اگر SSL مشکل دارد
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if (!$response || $httpCode !== 200) {
        // اگر API جواب نداد، سیاست محافظه‌کارانه: حذف کن
        return ['detected' => true, 'reason' => 'api_failed'];
    }

    $result = json_decode($response, true);
    if (!$result) return ['detected' => true, 'reason' => 'invalid_json'];

    // ✅ بررسی دقیق‌تر با آستانه کمتر
    if (isset($result['nudity'])) {
        $nudity = $result['nudity'];
        $rawScore = $nudity['raw'] ?? 0;
        $partialScore = $nudity['partial'] ?? 0;
        $safeScore = $nudity['safe'] ?? 1;

        // 🔥 آستانه کاهش یافته برای حساسیت بیشتر
        if ($rawScore > 0.40 || $partialScore > 0.65 || $safeScore < 0.50) {
            return ['detected' => true, 'reason' => 'nudity'];
        }
    }

    // ✅ بررسی محتوای تهاجمی
    if (isset($result['offensive'])) {
        $offensive = $result['offensive'];
        if (($offensive['prob'] ?? 0) > 0.60) {
            return ['detected' => true, 'reason' => 'offensive'];
        }
    }
    
    return ['detected' => false];
}

function checkTextContent(string $text): bool
{
    global $badWordsList;
    $text = mb_strtolower($text, 'UTF-8');
    
    foreach ($badWordsList as $word) {
        if (mb_strpos($text, $word) !== false) {
            return true;
        }
    }
    return false;
}

// ═══════════════════════════════════════════════════════
// 🔍 اسکن خودکار
// ═══════════════════════════════════════════════════════
function scanForPorn(array $message): void
{
    $chatId = $message['chat']['id'];
    $messageId = $message['message_id'];
    $userId = $message['from']['id'];
    $chatType = $message['chat']['type'] ?? '';

    if ($chatType !== 'supergroup') return;

    // بررسی وضعیت قفل
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("SELECT is_active, expire_time FROM mia_locks WHERE group_id = ? AND lock_type = 'porn'");
    $stmt->execute([$chatId]);
    $lockData = $stmt->fetch();
    
    if (!$lockData || $lockData['is_active'] != 1) return;

    // چک انقضا
    if ($lockData['expire_time'] && strtotime($lockData['expire_time']) < time()) {
        deactivatePornLock($chatId);
        return;
    }

    // استثناها (ادمین‌ها)
    if (isPornFilterExempt($chatId, $userId)) return;

    $isDetected = false;
    $detectionType = '';

    // 1. بررسی متن
    $textToCheck = $message['text'] ?? $message['caption'] ?? '';
    if (!empty($textToCheck) && checkTextContent($textToCheck)) {
        $isDetected = true;
        $detectionType = 'متن نامناسب';
    }

    // 2. بررسی مدیا
    if (!$isDetected) {
        $fileId = null;
        $mediaType = '';

        if (isset($message['photo'])) {
            $fileId = end($message['photo'])['file_id'];
            $mediaType = 'عکس';
        } elseif (isset($message['sticker'])) {
            // ✅ هر استیکری (حتی بدون thumb) در حالت قفل پورن حذف شود
            $isDetected = true;
            $detectionType = 'استیکر';
        } elseif (isset($message['animation'])) {
            // ✅ تمام گیف‌ها مشکوک
            $fileId = $message['animation']['thumb']['file_id'] ?? null;
            $mediaType = 'گیف';
        } elseif (isset($message['video'])) {
            $fileId = $message['video']['thumb']['file_id'] ?? null;
            $mediaType = 'ویدیو';
        }

        // بررسی تصویر با AI (فقط برای عکس/گیف/ویدیو)
        if ($fileId && $mediaType !== 'استیکر') {
            $fileUrl = getTelegramFilePath($fileId);
            if ($fileUrl) {
                $aiCheck = checkImageWithAI($fileUrl);
                if ($aiCheck['detected']) {
                    $isDetected = true;
                    $detectionType = $mediaType . ' (AI: ' . ($aiCheck['reason'] ?? 'detected') . ')';
                }
            }
        }
    }

    // 3. اقدامات
    if ($isDetected) {
        deleteMessage($chatId, $messageId);

        $warningCount = addWarning($chatId, $userId);
        $userMention = "<a href='tg://user?id={$userId}'>" . htmlspecialchars($message['from']['first_name']) . "</a>";

        if ($warningCount >= 6) {
            tgRequest('restrictChatMember', [
                'chat_id' => $chatId,
                'user_id' => $userId,
                'permissions' => json_encode(['can_send_messages' => false])
            ]);
            resetWarning($chatId, $userId);
            
            sendMessage($chatId, "⛔️ <b>کاربر {$userMention} به دلیل ارسال مکرر محتوای مستهجن سکوت شد.</b>");
        } else {
            $text = "🔞 <b>سیستم ضد پورن</b>\n\n";
            $text .= "👤 کاربر: {$userMention}\n";
            $text .= "⚠️ نوع: {$detectionType}\n";
            $text .= "🔢 اخطار: {$warningCount}/6";
            sendMessage($chatId, $text);
        }
    }
}

// ═══════════════════════════════════════════════════════
// 🎛️ مدیریت قفل
// ═══════════════════════════════════════════════════════
function activatePornLock(int $chatId, ?int $duration = null, string $unit = 'day'): string
{
    $db = Database::instance()->pdo();
    
    if ($duration !== null) {
        if ($unit === 'hour') {
            $expireTime = date('Y-m-d H:i:s', strtotime("+{$duration} hours"));
            $durationText = "{$duration} ساعت";
            $expireDisplay = "امروز " . jdate('H:i', strtotime($expireTime));
        } else {
            $expireTime = date('Y-m-d H:i:s', strtotime("+{$duration} days"));
            $durationText = "{$duration} روز";
            $expireDisplay = jdate('Y/m/d H:i', strtotime($expireTime));
        }
    } else {
        $expireTime = null;
        $durationText = "نامحدود";
        $expireDisplay = "ندارد";
    }
    
    $stmt = $db->prepare("
        INSERT INTO mia_locks (group_id, lock_type, is_active, expire_time) 
        VALUES (?, 'porn', 1, ?) 
        ON DUPLICATE KEY UPDATE is_active = 1, expire_time = VALUES(expire_time)
    ");
    $stmt->execute([$chatId, $expireTime]);
    
    return "✅ <b>آنتی پورن فعال شد</b>\n⏳ مدت: {$durationText}\n📅 انقضا: {$expireDisplay}";
}

function deactivatePornLock(int $chatId): void
{
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("UPDATE mia_locks SET is_active = 0, expire_time = NULL WHERE group_id = ? AND lock_type = 'porn'");
    $stmt->execute([$chatId]);
    
    // اعلان انقضا
    $text = "⏰ <b>قفل پورن به پایان رسید</b>\n\n";
    $text .= "🔓 سیستم آنتی پورن غیرفعال شد.\n";
    $text .= "📅 " . jdate('Y/m/d H:i');
    
    sendMessage($chatId, $text);
    sendMessage(SUDO_ID, "🔔 قفل پورن در گروه <code>{$chatId}</code> منقضی شد.");
}

function getPornLockStatus(int $chatId): array
{
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("SELECT is_active, expire_time FROM mia_locks WHERE group_id = ? AND lock_type = 'porn'");
    $stmt->execute([$chatId]);
    return $stmt->fetch() ?: ['is_active' => 0, 'expire_time' => null];
}

// ═══════════════════════════════════════════════════════
// 🎮 دستورات
// ═══════════════════════════════════════════════════════
function handlePornLockCommand(array $message): void
{
    $chatId = $message['chat']['id'];
    $userId = $message['from']['id'];
    $text = trim($message['text'] ?? '');
    $messageId = $message['message_id'];
    
    if ($userId != SUDO_ID) {
        sendMessage($chatId, "⛔️ این دستور فقط توسط مالک ربات قابل استفاده است.", null, $messageId);
        return;
    }

    $status = getPornLockStatus($chatId);

    // قفل پورن (دائمی)
    if ($text === 'قفل پورن') {
        if ($status['is_active']) {
            sendMessage($chatId, "ℹ️ قفل پورن در حال حاضر فعال است.", null, $messageId);
            return;
        }
        
        $response = activatePornLock($chatId);
        sendMessage($chatId, $response, null, $messageId);
    }
    // باز کردن پورن
    elseif ($text === 'بازکردن پورن' || $text === 'باز کردن پورن') {
        if (!$status['is_active']) {
            sendMessage($chatId, "ℹ️ قفل پورن در حال حاضر غیرفعال می‌باشد.", null, $messageId);
            return;
        }
        
        deactivatePornLock($chatId);
        sendMessage($chatId, "❌ آنتی پورن غیرفعال شد.", null, $messageId);
    }
    // پورن X (روز)
    elseif (preg_match('/^پورن\s+(\d+)$/u', $text, $matches)) {
        $days = (int)$matches[1];
        if ($days < 1 || $days > 365) {
            sendMessage($chatId, "❌ تعداد روز باید بین 1 تا 365 باشد.", null, $messageId);
            return;
        }
        
        $response = activatePornLock($chatId, $days, 'day');
        sendMessage($chatId, $response, null, $messageId);
    }
    // پورن X مین (ساعت)
    elseif (preg_match('/^پورن\s+(\d+)\s+مین$/u', $text, $matches)) {
        $hours = (int)$matches[1];
        if ($hours < 1 || $hours > 24) {
            sendMessage($chatId, "❌ تعداد ساعت باید بین 1 تا 24 باشد.", null, $messageId);
            return;
        }
        
        $response = activatePornLock($chatId, $hours, 'hour');
        sendMessage($chatId, $response, null, $messageId);
    }
    // پاک کردن اخطارها
    elseif ($text === 'پاک کردن اخطارها' && isset($message['reply_to_message'])) {
        $targetId = $message['reply_to_message']['from']['id'];
        resetWarning($chatId, $targetId);
        sendMessage($chatId, "✅ اخطارهای کاربر پاک شد.", null, $messageId);
    }
}

function processPornCommand(array $message): bool
{
    $text = trim($message['text'] ?? '');
    
    if ($text === 'قفل پورن' || 
        $text === 'بازکردن پورن' || 
        $text === 'باز کردن پورن' ||
        $text === 'پاک کردن اخطارها' ||
        preg_match('/^پورن\s+\d+$/u', $text) ||
        preg_match('/^پورن\s+\d+\s+مین$/u', $text)) {
        
        handlePornLockCommand($message);
        return true;
    }
    
    return false;
}

function processPornScan(array $message): void
{
    scanForPorn($message);
}

// ═══════════════════════════════════════════════════════
// 🗂️ توابع دیتابیس
// ═══════════════════════════════════════════════════════
function addWarning(int $groupId, int $userId): int
{
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("
        INSERT INTO user_warnings (group_id, user_id, warning_count) 
        VALUES (?, ?, 1) 
        ON DUPLICATE KEY UPDATE warning_count = warning_count + 1
    ");
    $stmt->execute([$groupId, $userId]);
    
    $stmt = $db->prepare("SELECT warning_count FROM user_warnings WHERE group_id = ? AND user_id = ?");
    $stmt->execute([$groupId, $userId]);
    return (int)$stmt->fetchColumn();
}

function resetWarning(int $groupId, int $userId): void
{
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("DELETE FROM user_warnings WHERE group_id = ? AND user_id = ?");
    $stmt->execute([$groupId, $userId]);
}

function isPornFilterExempt(int $groupId, int $userId): bool
{
    if ($userId == SUDO_ID) return true;
    
    $db = Database::instance()->pdo();
    
    // چک مقام MIR
    $tables = ['mir_owners', 'mir_deputies', 'mir_advisors'];
    foreach ($tables as $table) {
        try {
            $stmt = $db->prepare("SELECT 1 FROM {$table} WHERE group_id = ? AND user_id = ?");
            $stmt->execute([$groupId, $userId]);
            if ($stmt->fetch()) return true;
        } catch (PDOException $e) {
            continue;
        }
    }

    return false;
}

// ═══════════════════════════════════════════════════════
// ⏰ Cron Job (برای چک انقضا)
// ═══════════════════════════════════════════════════════
function checkExpiredPornLocks(): int
{
    $db = Database::instance()->pdo();
    $stmt = $db->prepare("
        SELECT group_id FROM mia_locks 
        WHERE lock_type = 'porn' 
        AND is_active = 1 
        AND expire_time IS NOT NULL 
        AND expire_time <= NOW()
    ");
    $stmt->execute();
    $expired = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    foreach ($expired as $groupId) {
        deactivatePornLock($groupId);
    }
    
    return count($expired);
}
?>